@extends('installer.layout')

@section('title', 'Complete')
@section('subtitle', 'Installation completed successfully')

@section('content')
    <div style="text-align: center;">
        <div class="completion-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        
        <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Installation Completed!</h2>
        
        <p style="margin-bottom: var(--spacing-xl);">
            Your application has been successfully installed and configured. You can now start using your application.
        </p>
        
        <div class="info-card" style="max-width: 450px; margin: 0 auto; text-align: left;">
            <h3><i class="fas fa-info-circle"></i> Installation Details</h3>
            
            <div class="info-item">
                <div class="info-label">Installation Date</div>
                <div class="info-value">{{ date('Y-m-d H:i:s') }}</div>
            </div>
            
            <div class="info-item">
                <div class="info-label">Application URL</div>
                <div class="info-value">{{ session('app_url') }}</div>
            </div>
        </div>
        
        <div style="margin-top: var(--spacing-xl); background-color: rgba(76, 217, 100, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-lg); text-align: left; border: 1px solid rgba(76, 217, 100, 0.2);">
            <div style="display: flex; align-items: flex-start;">
                <i class="fas fa-lightbulb" style="color: var(--success); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
                <div>
                    <p style="font-weight: 500; margin-bottom: var(--spacing-xs);">What's next?</p>
                    <ul style="padding-left: var(--spacing-lg); margin-bottom: 0;">
                        <li style="margin-bottom: var(--spacing-xs);">Login with Steam! The first user to login is given super-admin role!</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footer')
    <div></div>
    <a href="{{ url('/') }}" class="btn btn-success">
        <i class="fas fa-home"></i> Go to Homepage
    </a>
@endsection